@echo off
CHCP 65001 > NUL
TITLE RemBG Installation
:: Installiert rembg fuer Hintergrundentfernung
setlocal

:: Pruefen ob Python installiert ist
where python >nul 2>&1
IF %ERRORLEVEL% NEQ 0 (
    echo Python wurde nicht gefunden!
    echo Bitte installieren Sie Python 3.10+ von python.org oder dem Microsoft Store.
    echo.
    pause
    exit /b 1
)

:: Python Version anzeigen
echo Gefundene Python-Version:
python --version
echo.

:: Nachfragen ob der Benutzer sicher ist
IF "%1"=="/quiet" GOTO INSTALLATION

echo Diese Installation richtet rembg fuer die Hintergrundentfernung ein.
echo Es werden folgende Pakete installiert:
echo   - rembg (Hintergrundentfernung)
echo   - onnxruntime (KI-Inferenz)
echo.
SET /P AREYOUSURE=Moechten Sie mit der Installation fortfahren (Y/[N])?
IF /I "%AREYOUSURE%" NEQ "Y" GOTO ABORT

:INSTALLATION
echo.
echo ========================================
echo Installation wird gestartet...
echo ========================================
echo.

:: Pip upgraden
echo [1/5] Pip wird aktualisiert...
python -m pip install --upgrade pip --quiet

:: onnxruntime installieren (CPU-Version, funktioniert immer)
echo [2/5] onnxruntime wird installiert...
python -m pip install onnxruntime --quiet

:: rembg installieren
echo [3/5] rembg wird installiert...
python -m pip install rembg --quiet

:: Modell fuer Menschen herunterladen (u2net_human_seg)
echo [4/5] Modell wird heruntergeladen (u2net_human_seg)...
echo       Dies kann einige Minuten dauern beim ersten Mal...
python -c "from rembg import remove, new_session; session = new_session('u2net_human_seg'); print('Modell erfolgreich geladen!')"

:: Testen ob rembg funktioniert
echo [5/5] Installation wird getestet...
python -c "from rembg import remove; print('rembg erfolgreich installiert!')"

IF %ERRORLEVEL% NEQ 0 (
    echo.
    echo FEHLER: rembg konnte nicht installiert werden!
    echo Bitte pruefen Sie die Fehlermeldungen oben.
    pause
    exit /b 1
)

echo.
echo ========================================
echo Installation erfolgreich abgeschlossen!
echo ========================================
echo.
echo Verfuegbare Modelle:
echo   - u2net_human_seg (Standard, fuer Menschen optimiert)
echo   - u2net (allgemein)
echo   - birefnet (beste Qualitaet, langsamer)
echo.
echo Das Modell kann in CanPrint unter Einstellungen geaendert werden.
echo.

GOTO END

:ABORT
echo.
echo Installation abgebrochen.
GOTO END

:END
IF "%1" NEQ "/quiet" pause
endlocal
